unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, VLAVIPlayer, ExtCtrls, SLStreamTypes, VLCommonDisplay,
  VLImageDisplay, VLDSVideoPlayer, ComCtrls, VLCommonFilter, VLFrameChange,
  LPComponent, MLDSPlayer, LPControl, SLControlCollection;

type
  TForm2 = class(TForm)
    VLDSVideoPlayer1: TVLDSVideoPlayer;
    Panel1: TPanel;
    Panel2: TPanel;
    CB: TComboBox;
    VLImageDisplay1: TVLImageDisplay;
    Label1: TLabel;
    Panel3: TPanel;
    btnStart: TButton;
    TB: TTrackBar;
    Label2: TLabel;
    btnStop: TButton;
    btnPause: TButton;
    btnResume: TButton;
    Label3: TLabel;
    Label4: TLabel;
    procedure btnStartClick(Sender: TObject);
    procedure CBChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure VLDSVideoPlayer1Progress(Sender: TObject; StartFrame,
      EndFrame, CurrentFrame: Int64);
    procedure TBChange(Sender: TObject);
    procedure VLDSVideoPlayer1Stop(Sender: TObject);
    procedure btnPauseClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnResumeClick(Sender: TObject);
  private
    FOldWnd         : TWndMethod;
    FButtonDown     : Boolean;
  private
    procedure SliderWndProc(var Message: TMessage);
  public
    procedure Init;
  end;

var
  Form2: TForm2;

implementation

uses CommCtrl, Unit1;

{$R *.dfm}

{ TForm2 }

procedure TForm2.Init;
var sr: TSearchRec;
begin
  CB.Items.Clear;
  if FindFirst('*.avi', faArchive, sr) = 0 then begin
    repeat
      if Form1.VLAVILogger1.FileName <> sr.Name then
        CB.Items.Add(sr.Name);
    until FindNext(sr) <> 0;
    FindClose(sr);
  end;
//  if CB.Items.Count > 0 then
//    CB.ItemIndex := 0;
end;

procedure TForm2.btnStartClick(Sender: TObject);
var w, h : integer;
begin
  TB.Enabled := True;

  btnPause.Enabled := True;
  btnStop.Enabled := True;
  btnStart.Enabled := False;

  // Make sure the component is not paused.
  VLDSVideoPlayer1.Paused := False;

  VLDSVideoPlayer1.Start;
  Label1.Caption := IntToStr(VLDSVideoPlayer1.Width)+'x'+IntToStr(VLDSVideoPlayer1.Height);
  Label4.Caption := VLDSVideoPlayer1.VideoCodecName;
  w := Width - ClientWidth;
  h := Height - ClientHeight;
  Width := VLDSVideoPlayer1.Width+w;
  Height := VLDSVideoPlayer1.Height+Panel2.Height+Panel3.Height+h;
  Position := poDesktopCenter;
end;

procedure TForm2.CBChange(Sender: TObject);
var s : string;
begin
  s := ExtractFilePath(Application.ExeName)+ CB.Text;
  Form2.btnStop.Click;
  VLDSVideoPlayer1.FileName := S;
  Form2.btnStart.Click;
end;

procedure TForm2.FormCreate(Sender: TObject);
begin
  FOldWnd := TB.WindowProc;
  TB.WindowProc := SliderWndProc;
end;

procedure TForm2.FormClose(Sender: TObject; var Action: TCloseAction);
begin

  Form2.btnStop.Click;
//  VLDSVideoPlayer1.OnProgress := NIL;
//  VLDSVideoPlayer1.OnStop := NIL;
  VLDSVideoPlayer1.Close;

//  TB.OnChange := NIL;
  TB.WindowProc := FOldWnd;

end;

procedure TForm2.VLDSVideoPlayer1Progress(Sender: TObject; StartFrame,
  EndFrame, CurrentFrame: Int64);
begin
{
  MSec := VLDSVideoPlayer1.CurrentTime div 10000;
  Seconds := MSec div 1000;
  MSec := MSec div 10;
  MSec := MSec mod 100;
  Minutes := Seconds div 60;
  Seconds := Seconds mod 60;
  Label2.Caption := IntToStr(Minutes) + ':' + IntToStr(Seconds) + ':' + IntToStr(MSec);
}
  Label2.Caption := FloatToStrF(VLDSVideoPlayer1.CurrentTime / 10000000, ffFixed, 10,	1)+'/'+
                    FloatToStrF(VLDSVideoPlayer1.DurationTime / 10000000, ffFixed, 10, 1);
  if not FButtonDown then begin
    TB.OnChange := NIL;
    TB.Max := VLDSVideoPlayer1.FramesCount;
    TB.Position := VLDSVideoPlayer1.CurrentFrame;
    TB.OnChange := TBChange;
  end;

{

  TB.Min := StartFrame;
  TB.Max := EndFrame;
  TB.Position := CurrentFrame;
  Label2.Caption := FloatToStrF(VLDSVideoPlayer1.CurrentTime / 10000000, ffFixed, 10,	1)+'/'+
                    FloatToStrF(VLDSVideoPlayer1.DurationTime / 10000000, ffFixed, 10, 1)
}
end;

procedure TForm2.TBChange(Sender: TObject);
begin
//  VLImageDisplay1.;
  VLDSVideoPlayer1.CurrentFrame := TB.Position;
end;

procedure TForm2.VLDSVideoPlayer1Stop(Sender: TObject);
begin

  TB.Enabled := False;
  TB.OnChange := NIL;
  TB.Position := 0;
  TB.OnChange := TBChange;
  Form2.btnStop.Click;
end;

procedure TForm2.btnPauseClick(Sender: TObject);
begin
  VLDSVideoPlayer1.Pause();

  btnPause.Enabled := False;
  btnResume.Enabled := True;
end;

procedure TForm2.btnStopClick(Sender: TObject);
begin
  VLDSVideoPlayer1.Stop;
  btnResume.Enabled := False;
  btnPause.Enabled := False;
  btnStop.Enabled := False;
  btnStart.Enabled := True;
end;

procedure TForm2.SliderWndProc(var Message: TMessage);
var
  APos : Integer;
  WorkArea : TRect;
  AWidth : Integer;
begin
  // Check if the left mouse button is down.
  if Message.Msg = WM_LBUTTONDOWN then begin
    if VLDSVideoPlayer1.Enabled then begin
      if not VLDSVideoPlayer1.Paused then begin
        // If the player is playing pause it while we seek to prevent noise.
        VLDSVideoPlayer1.Pause;
        FButtonDown := True;
      end;
    end;

    // This is beginning of optional code
    // Improves the standard slider component.
    // Moves the slider to the place the mouse has been pressed down.
    APos := TWMMouse( Message ).XPos;
    SendMessage(TB.Handle, TBM_GETCHANNELRECT, 0, Integer( @WorkArea ));
    AWidth := SendMessage(TB.Handle, TBM_GETTHUMBLENGTH, 0, 0 );
    Dec( APos, 4 );
    AWidth := WorkArea.Right - WorkArea.Left - ( AWidth div 2 );
    if APos > WorkArea.Right then
      APos := AWidth
    else if APos < WorkArea.Left then
      APos := 0
    else
      APos := APos - WorkArea.Left;

    TB.Position := Round(APos * TB.Max / AWidth);
    // End of the optional code.

  end else
    if Message.Msg = WM_LBUTTONUP then begin
      if FButtonDown then begin
        VLDSVideoPlayer1.CurrentFrame := TB.Position;
        VLDSVideoPlayer1.Resume();
        FButtonDown := False;
      end;
    end;

  FOldWnd( Message);
end;

procedure TForm2.btnResumeClick(Sender: TObject);
begin
  VLDSVideoPlayer1.Resume();

  btnPause.Enabled := True;
  btnResume.Enabled := False;
end;

end.
