unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  VLCommonFilter, VLGenericFilter, ExtCtrls, VLMotionDetect, VLDSCapture,
  Grids, VLCommonDisplay, VLImageDisplay, StdCtrls, TLBasicTimingFilter,
  TLWatchDogTimer, VLDraw, SLComponentCollection, LPDrawLayers,
  SLStreamTypes, VLVideoCompressor, VLCommonLogger, VLAVILogger,
  SLCommonFilter, SLGenericFilter, VLBasicDrawLayers, VLAVIPlayer,
  VLBasicGenericFilter, VLSinkFilter, VLVisionStreamTypes, LPComponent,
  LPControl, SLControlCollection, MLDSPlayer, VLDSVideoPlayer, TLClockGen,
  ComCtrls, Buttons, DateUtils, AppEvnts, RXShell, Menus, NiceSettings,
  VLCompression, ShellApi, VLDSVideoLogger;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    StartButton: TButton;
    StopButton: TButton;
    VLImageDisplay1: TVLImageDisplay;
    VLImageDisplay2: TVLImageDisplay;
    VLMotionDetect1: TVLMotionDetect;
    CheckBox1: TCheckBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    StringGrid: TStringGrid;
    CheckBox2: TCheckBox;
    Shape1: TShape;
    TLWatchDogTimer1: TTLWatchDogTimer;
    VLDraw1: TVLDraw;
    VLDrawMotionsLayer1: TVLDrawMotionsLayer;
    CheckBox4: TCheckBox;
    VLAVILogger1: TVLAVILogger;
    Label4: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Button3: TButton;
    VLDSVideoPlayer1: TVLDSVideoPlayer;
    OpenDialog1: TOpenDialog;
    TLClockGen1: TTLClockGen;
    VLGenericFilter1: TVLGenericFilter;
    ProgressBar1: TProgressBar;
    VLDrawTextLayer1: TVLDrawTextLayer;
    VLGenericFilter2: TVLGenericFilter;
    VLDraw2: TVLDraw;
    VLDrawTextLayer2: TVLDrawTextLayer;
    CheckBox3: TCheckBox;
    RxTrayIcon1: TRxTrayIcon;
    ApplicationEvents1: TApplicationEvents;
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    About: TMenuItem;
    Open: TMenuItem;
    Quit: TMenuItem;
    ComboBox1: TComboBox;
    NiceSettings1: TNiceSettings;
    Memo1: TMemo;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    Label5: TLabel;
    VLDSVideoLogger1: TVLDSVideoLogger;
    BitBtn1: TBitBtn;
    procedure StartButtonClick(Sender: TObject);
    procedure StopButtonClick(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure VLGenericFilter1ProcessData(Sender: TObject;
      InBuffer: IVLImageBuffer; var OutBuffer: IVLImageBuffer;
      var SendOutputData: Boolean);
    procedure CheckBox2Click(Sender: TObject);
    procedure TLWatchDogTimer1Timer(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button3Click(Sender: TObject);
    procedure VLMotionDetect1MotionDetected(Sender: TObject;
      Motions: TVLMotions);
    procedure VLDSVideoPlayer1Stop(Sender: TObject);
    procedure VLImageDisplay2Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure VLDSVideoPlayer1Progress(Sender: TObject; StartSample,
      EndSample, CurrentSample: Int64);
    procedure VLImageDisplay1Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure ApplicationEvents1Minimize(Sender: TObject);
    procedure StringGridClick(Sender: TObject);
    procedure AboutClick(Sender: TObject);
    procedure OpenClick(Sender: TObject);
    procedure QuitClick(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure VLAVILogger1Error(Sender: TObject; ErrorText: String;
      ErrorCode: Integer; var Handled: Boolean);
    procedure RxTrayIcon1Click(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure WMDropFiles (var Msg: TMessage); message wm_DropFiles;
    procedure CheckBox6Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);

  private

  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Ind : integer;

implementation

uses Unit2, Unit3;

{$R *.dfm}

//   LOG 
procedure Log(Text:string);
var
  F : TextFile;
  FileName : String;
  dt:string;
begin
  FileName := ExtractFilePath(Application.ExeName) + 'Log.txt';
  AssignFile(F, FileName);
  if FileExists(FileName) then
    Append(F)
  else
    Rewrite(F);
    dt:=DateToStr(Date);
    dt:=dt+' '+TimeToStr(Time);
  WriteLn(F, dt+': ' +text);
  CloseFile(F);
end;

//      DragnDrop
//  c  1/3,     
procedure TForm1.WMDropFiles (var Msg: TMessage);
var
  Amount, size, i: integer;
  Filename: PAnsiChar;
  D : string;
begin
  inherited;
  Amount := DragQueryFile(Msg.WParam, $FFFFFFFF, Filename, 255);
  for i := 0 to (Amount - 1) do
  begin
  size := DragQueryFile(Msg.WParam, i, nil, 0) + 1;
  Filename := StrAlloc(size);
  DragQueryFile(Msg.WParam, i, Filename, size);
//  ShowMessage(StrPas(Filename));
  if Pos(LowerCase(ExtractFileExt(Filename)),OpenDialog1.Filter)>0 then
     begin
        OpenDialog1.Files.Add(Filename);
        Form1.Caption:='  ( '+ IntToStr(Ind+1) + '/' + IntToStr(OpenDialog1.Files.Count)+')';
     end;
  if (not VLDSVideoPlayer1.Opened) and (OpenDialog1.Files.Count>0) then
       begin
        CheckBox2.Enabled := False;
        DateTimeToString(D, 'yymmdd_hhnnss', Now);
        VLAVILogger1.FileName := ChangeFileExt(ExtractFileName(OpenDialog1.Files.Strings[Ind]), '')+'_'+D+'.avi';
        VLAVILogger1.Enabled := CheckBox6.Checked;
        VLDSVideoPlayer1.FileName:=OpenDialog1.Files.Strings[Ind];
        if CheckBox5.Checked then Log('open file ' + VLDSVideoPlayer1.FileName);
        StopButton.Enabled := True;
        StartButton.Enabled := False;
        RxTrayIcon1.Animated := True;
        VLDSVideoPlayer1.Paused := False;
        VLDSVideoPlayer1.Start;
        Label5.Caption:=VLDSVideoPlayer1.VideoCodecName;        
        VLDrawTextLayer1.Font.Size:=Round(VLDSVideoPlayer1.Width / 64)+2;
        VLDrawTextLayer2.Font.Size:=VLDrawTextLayer1.Font.Size;
        TLClockGen1.Start;
       end;
  StrDispose(Filename);
  end;
  DragFinish(Msg.WParam);
end;

//     
procedure TForm1.StartButtonClick(Sender: TObject);
begin
  StopButton.Enabled := True;
  StartButton.Enabled := False;
  VLDSVideoPlayer1.Paused := False;
  RxTrayIcon1.Animated := True;
  Memo1.Text:=VLAVILogger1.Compression.Compressions.Items[0].Name;
  ComboBox1.Enabled := False;
end;

//     
procedure TForm1.StopButtonClick(Sender: TObject);
begin
  StopButton.Enabled := False;
  StartButton.Enabled := True;
  VLDSVideoPlayer1.Paused := True;
  RxTrayIcon1.Animated := False;
  ComboBox1.Enabled := True;
end;

//  ,   
procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  VLMotionDetect1.NoiseReduction.Enabled := CheckBox1.Checked;
end;

//        
procedure TForm1.VLGenericFilter1ProcessData(Sender: TObject;
  InBuffer: IVLImageBuffer; var OutBuffer: IVLImageBuffer;
  var SendOutputData: Boolean);
var
  X, Y : Integer;
  T : TDateTime;
  D : String;
begin
  StringGrid.ColCount := VLMotionDetect1.MotionGrid.Cols;
  StringGrid.RowCount := VLMotionDetect1.MotionGrid.Rows;

  for X := 0 to StringGrid.ColCount - 1 do
    for Y := 0 to StringGrid.RowCount - 1 do
      StringGrid.Cells[ X, Y ] := IntToStr( VLMotionDetect1.Items[ X, Y ] );

//   TimeCode    
  T:=FileDateToDateTime(FileAge(OpenDialog1.Files.Strings[Ind]));
  T:=IncMilliSecond(T, -Trunc(( VLDSVideoPlayer1.DurationTime - VLDSVideoPlayer1.CurrentTime ) / 10000));
  DateTimeToString(D, 'dd.mm.yyyy  hh:nn:ss', T);
  VLDrawTextLayer1.Text := D;
  VLDrawTextLayer2.Text := D;
end;

//  ,   
procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  VLMotionDetect1.Enabled := CheckBox2.Checked;
  if CheckBox2.Checked then
       begin
         VLDraw2.InputPin.Connect(VLMotionDetect1.OutputPin);
         Label3.Caption := ' ';
       end
     else
       begin
         VLDraw2.InputPin.Connect(VLDSVideoPlayer1.OutputPin);
         Label3.Caption := ' !';         
       end;
//  CheckBox2.Enabled := False;
//  VLDraw2.InputPin.Connect(VLDSVideoPlayer1.OutputPin)
//  VLDraw2.InputPin.Connect(VLMotionDetect1.OutputPin);
end;

//    (3 .)   
procedure TForm1.TLWatchDogTimer1Timer(Sender: TObject);
begin
  Shape1.Brush.Color := clLime;
  Label3.Caption := ' ';
  if CheckBox5.Checked then Log('end move frame '+FloatToStr(VLDSVideoPlayer1.CurrentFrame));
//  VLImageDisplay2.Visible := False;
end;

//  ,    
procedure TForm1.CheckBox4Click(Sender: TObject);
begin
  VLDrawMotionsLayer1.Visible := CheckBox4.Checked;
end;

//   
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var F : String;
begin
  DragAcceptFiles(Handle, false);
  StopButton.Enabled:=False;
  if (VLAVILogger1.CurrentFrame=0) and (OpenDialog1.Files.Count>0) then
     F:=ExtractFilePath(OpenDialog1.Files.Strings[Ind]) + VLAVILogger1.FileName;
  VLAVILogger1.Close;
  VLAVILogger1.Enabled := False;
  if CheckBox5.Checked then Log('close file ' + VLDSVideoPlayer1.FileName);
  VLDSVideoPlayer1.Stop;
  VLDSVideoPlayer1.Close;
  if Length(F)>0 then DeleteFile(F);
  NiceSettings1.SaveSettings;
end;

//    ( )
procedure TForm1.Button3Click(Sender: TObject);
begin
  Form2.Init;
  Form2.Show;
end;

//       
procedure TForm1.VLMotionDetect1MotionDetected(Sender: TObject;
  Motions: TVLMotions);
begin
  if Shape1.Brush.Color = clLime then
  begin
   Label3.Caption := '  ';
   Shape1.Brush.Color := clRed;
   if CheckBox5.Checked then Log('begin move frame '+FloatToStr(VLDSVideoPlayer1.CurrentFrame));
  end;
//  VLImageDisplay2.Visible := True;
end;

//       ( )
//  c  2/3,      
procedure TForm1.VLDSVideoPlayer1Stop(Sender: TObject);
var D,F : string;
begin
     if (StopButton.Enabled) and (Ind < OpenDialog1.Files.Count-1) then
     begin
       F:='';
       if VLAVILogger1.CurrentFrame = 0 then
          F:=ExtractFilePath(OpenDialog1.Files.Strings[Ind]) + VLAVILogger1.FileName;
       Ind:=Ind+1;

       if CheckBox5.Checked then Log('close file ' + VLDSVideoPlayer1.FileName);
       VLDSVideoPlayer1.Stop;
       VLDSVideoPlayer1.Close;
       VLDSVideoPlayer1.FileName:=OpenDialog1.Files.Strings[Ind];

       if CheckBox5.Checked then Log('open file ' + VLDSVideoPlayer1.FileName);

       DateTimeToString(D, 'yymmdd_hhnnss', Now);
       VLAVILogger1.Close;
//       VLAVILogger1.FileName := D+'.avi';
       VLAVILogger1.FileName := ChangeFileExt(ExtractFileName(OpenDialog1.Files.Strings[Ind]), '')+'_'+D+'.avi';
       VLAVILogger1.Enabled := CheckBox6.Checked;

       if Length(F)>0 then DeleteFile(F);
       Form1.Caption:='  ( '+ IntToStr(Ind+1) + '/' + IntToStr(OpenDialog1.Files.Count)+')';

       VLGenericFilter1.Enabled := True;
       VLDSVideoPlayer1.Paused := False;
       try
         VLDSVideoPlayer1.Start;
         Label5.Caption:=VLDSVideoPlayer1.VideoCodecName;         
         VLDrawTextLayer1.Font.Size:=Round(VLDSVideoPlayer1.Width / 64)+2;
         VLDrawTextLayer2.Font.Size:=VLDrawTextLayer1.Font.Size;
         TLClockGen1.Start;
         Exit;
       except
         VLDSVideoPlayer1.Close;
         VLDSVideoPlayer1Stop(Button3);
       end;
     end;
  ProgressBar1.Position:=100;
  RxTrayIcon1.Animated := False;
  StopButton.Enabled := False;
  StartButton.Enabled := False;
  Form1.Caption:=Form1.Caption + '  !';
  Ind:=0;
  CheckBox2.Enabled := True;
  OpenDialog1.Files.Clear;
  VLDSVideoPlayer1.Stop;
  VLDSVideoPlayer1.Close;
  VLAVILogger1.Close;
  TLClockGen1.Stop;
  ComboBox1.Enabled := True;
end;

//     
procedure TForm1.VLImageDisplay2Click(Sender: TObject);
begin
  if VLImageDisplay2.Align=alNone then
    begin
     StringGrid.Visible:=False;
     Bevel1.Visible:=False;
     VLImageDisplay1.Visible:=False;
     VLImageDisplay2.Align:=alClient;  //alClient;
    end
  else
    begin
     Form1.FormResize(VLImageDisplay2);
    end;
end;

//        
procedure TForm1.FormResize(Sender: TObject);
begin
     VLImageDisplay1.Align:=alNone;
     VLImageDisplay1.Left:=Bevel1.Left+2;
     VLImageDisplay1.Top:=Bevel1.Top+1;
     VLImageDisplay1.Height:=Bevel1.Height-3;
     VLImageDisplay1.Width:=Bevel1.Width-5;

     VLImageDisplay2.Align:=alNone;
     VLImageDisplay2.Left:=Bevel2.Left+2;
     VLImageDisplay2.Top:=Bevel2.Top+1;
     VLImageDisplay2.Height:=Bevel2.Height-3;
     VLImageDisplay2.Width:=Bevel2.Width-5;

     StringGrid.Visible:=True;
     Bevel1.Visible:=True;
     Bevel2.Visible:=True;
     VLImageDisplay1.Visible:=True;
     VLImageDisplay2.Visible:=True;
end;

//     (  )
procedure TForm1.VLDSVideoPlayer1Progress(Sender: TObject; StartSample,
  EndSample, CurrentSample: Int64);
begin
   if VLDSVideoPlayer1.DurationTime<>0 then ProgressBar1.Position:=round(100 * VLDSVideoPlayer1.CurrentTime / VLDSVideoPlayer1.DurationTime);
end;

//     
procedure TForm1.VLImageDisplay1Click(Sender: TObject);
begin
  if VLImageDisplay1.Align=alNone then
    begin
     StringGrid.Visible:=False;
     Bevel2.Visible:=False;
     VLImageDisplay2.Visible:=False;
     VLImageDisplay1.Align:=alClient;  //alClient;
    end
  else
    begin
     Form1.FormResize(VLImageDisplay1);
    end;
end;

//  ,  TimeCode (   )
procedure TForm1.CheckBox3Click(Sender: TObject);
begin
   VLDrawTextLayer1.Visible:=CheckBox3.Checked; //timecode  
   VLDrawTextLayer2.Visible:=CheckBox3.Checked; //timecode  
end;

//     
procedure TForm1.ApplicationEvents1Minimize(Sender: TObject);
begin
Form1.Visible := false;
RxTrayIcon1.Icon := Application.Icon;
RxTrayIcon1.Active := True;
end;

//         
procedure TForm1.StringGridClick(Sender: TObject);
var
  X, Y : Integer;
begin
  if VLMotionDetect1.MotionGrid.ShowDialog then
  begin
    StringGrid.ColCount := VLMotionDetect1.MotionGrid.Cols;
    StringGrid.RowCount := VLMotionDetect1.MotionGrid.Rows;
    StringGrid.Hint:='';
    for X := 0 to StringGrid.ColCount-1 do
    for Y := 0 to StringGrid.RowCount-1 do
      StringGrid.Hint:=StringGrid.Hint + IntToStr( VLMotionDetect1.MotionGrid.Items[ X, Y ] );
  end;
end;

//    
procedure TForm1.AboutClick(Sender: TObject);
begin
 if Form3.Visible then Form3.Close else Form3.Show;
end;

//      ...
//  c  3/3,      
procedure TForm1.OpenClick(Sender: TObject);
var D : string;
begin
  VLDSVideoPlayer1.Close;
  VLAVILogger1.Close;
  VLAVILogger1.Enabled := False;
  Memo1.Text:=VLAVILogger1.Compression.Compressions.Items[0].Name;
  ComboBox1.Enabled := False;
  CheckBox2.Enabled := False;
  OpenDialog1.InitialDir:=ExtractFilePath(Application.ExeName);
  if OpenDialog1.Execute then
  begin
//    CheckBox2.Enabled := False;
    Ind := 0;
    DateTimeToString(D, 'yymmdd_hhnnss', Now);
//    VLAVILogger1.FileName := D+'.avi';
    VLAVILogger1.FileName := ChangeFileExt(ExtractFileName(OpenDialog1.Files.Strings[Ind]), '')+'_'+D+'.avi';
    VLAVILogger1.Enabled := CheckBox6.Checked;
    VLDSVideoPlayer1.FileName:=OpenDialog1.Files.Strings[Ind];
    if CheckBox5.Checked then Log('open file ' + VLDSVideoPlayer1.FileName);
    StopButton.Enabled := True;
    StartButton.Enabled := False;
    Form1.Caption:='  ( '+ IntToStr(Ind+1) + '/' + IntToStr(OpenDialog1.Files.Count)+')';
    RxTrayIcon1.Animated := True;
    VLDSVideoPlayer1.Paused := False;
    try
      VLDSVideoPlayer1.Start;
      Label5.Caption:=VLDSVideoPlayer1.VideoCodecName;
      VLDrawTextLayer1.Font.Size:=Round(VLDSVideoPlayer1.Width / 64)+2;
      VLDrawTextLayer2.Font.Size:=VLDrawTextLayer1.Font.Size;
      TLClockGen1.Start;
    except
      VLDSVideoPlayer1.Close;
      VLDSVideoPlayer1Stop(Button3);
    end;
  end else ComboBox1.Enabled := True;
end;

//      
procedure TForm1.QuitClick(Sender: TObject);
begin
Form1.Close;
end;

//       
procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  VLAVILogger1.Compression.Compressions[0].Compressor:=ComboBox1.Text;
  Memo1.Text:=VLAVILogger1.Compression.Compressions.Items[0].Name;

//  VLDSVideoLogger1.VideoCompression.Compressions[0].Compressor:=ComboBox1.Text;
  VLDSVideoLogger1.VideoCompression.Compressions[0].Compressor:=Copy(VLAVILogger1.Compression.Compressions[0].Name,10,100);
  BitBtn1.Enabled:=VLDSVideoLogger1.VideoCompression.Compressions.Items[0].HasDialog;
end;

//      ,    
procedure TForm1.FormCreate(Sender: TObject);
var
  X, Y, I : Integer;
begin
// ciCode	- Return only FourCC code of the compression.
// ciDescription	- Return only description of the compression.
// ciBoth	- Return FourCC code and Description of the compression
  DragAcceptFiles(Handle, true);
  NiceSettings1.LoadSettings;
  VLDrawTextLayer1.Visible:=CheckBox3.Checked; //timecode  
  VLDrawTextLayer2.Visible:=CheckBox3.Checked; //timecode  
  ComboBox1.Items.Clear;
  VLAVILogger1.Compression.Compressions.GetAvailableCompressions(ComboBox1.Items,ciCode);
//  VLDSVideoLogger1.VideoCompression.GetCompressorList(ComboBox1.Items);

//  if ComboBox1.Text='' then ComboBox1.Text:=ComboBox1.Items[0];
  VLAVILogger1.Compression.Compressions[0].Compressor:=ComboBox1.Text;
  Memo1.Text:=VLAVILogger1.Compression.Compressions.Items[0].Name;

  VLDSVideoLogger1.VideoCompression.Compressions[0].Compressor:=Copy(VLAVILogger1.Compression.Compressions[0].Name,10,100);
  BitBtn1.Enabled:=VLDSVideoLogger1.VideoCompression.Compressions.Items[0].HasDialog;

  Ind := 0;
  VLMotionDetect1.MotionGrid.Cols := StringGrid.ColCount;
  VLMotionDetect1.MotionGrid.Rows := StringGrid.RowCount;
  I:=0;
  if Length(StringGrid.Hint)>0 then
   begin
    for X := 0 to StringGrid.ColCount-1 do
    for Y := 0 to StringGrid.RowCount-1 do
       begin
         I:=I+1;
         VLMotionDetect1.MotionGrid.Items[ X, Y ]:= StrToInt(StringGrid.Hint[I]);
       end;
   end;
  VLMotionDetect1.Enabled := CheckBox2.Checked;
  if CheckBox2.Checked then
       begin
         VLDraw2.InputPin.Connect(VLMotionDetect1.OutputPin);
         Label3.Caption := ' ';
       end
     else
       begin
         VLDraw2.InputPin.Connect(VLDSVideoPlayer1.OutputPin);
         Label3.Caption := ' !';         
       end;
end;

//     
procedure TForm1.VLAVILogger1Error(Sender: TObject; ErrorText: String;
  ErrorCode: Integer; var Handled: Boolean);
begin
  ShowMessage(' ' + ErrorText);
end;

//     
procedure TForm1.RxTrayIcon1Click(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
Form1.Visible := True;
RxTrayIcon1.Active := false;
Application.Restore;
//Form1.WindowState := wsNormal;
//Form1.WindowState := wsMaximized;
SetForegroundWindow(Form1.Handle);
end;

//  ,  
procedure TForm1.CheckBox6Click(Sender: TObject);
begin
 VLAVILogger1.Enabled := CheckBox6.Checked;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  VLDSVideoLogger1.VideoCompression.Compressions.Items[0].ShowDialog;
end;

end.

